<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../gUtil/DbManager.php";
    include "../../classi/GeneratoreUrl.php";
    include "../../classi/ecommerce/Carrello.php";
    include "../../classi/ecommerce/ConnettorePaypal.php";
    include "../../classi/Notifica.php";
    include "../../include/utilEcommerce.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb              = new DbManager($costantiDatabase);
    $impostazioni          = recuperaImpostazioni($geecomDb);
    $datiCMS               = $geecomDb->leggiSingolaRiga("geec_prodotti", 1);
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni", 1);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET, "operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idCarrello = (!isset($_SESSION["carrello"])) ? 0 : $_SESSION["carrello"];
    }
    else {
        $operazione = filter_input(INPUT_POST, "operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idCarrello = (!isset($_SESSION["carrello"])) ? 0 : $_SESSION["carrello"];
    }
 
    $carrello = new Carrello($geecomDb, $idCarrello);
    if(isset($_SESSION["geecomUser_id"]) && $_SESSION["geecomUser_id"]>0) {
    	$carrello->setIdUtente($_SESSION["geecomUser_id"]);
    }
    
    if(isset($_SESSION["geecomUser_idGruppo"]) && $_SESSION["geecomUser_idGruppo"]>0) {
    	$carrello->setGruppoUtente($_SESSION["geecomUser_idGruppo"]);
    }
    
    if($operazione=="elimina") {
	$carrello->elimina();
	unset($_SESSION["carrello"]);
	header("Location: ../../carrello.php");
    }
    else if($operazione=="eliminaProdotto") {
	$carrello->caricaDatiDalDatabase();
	$idProdotto = filter_input(INPUT_GET,"idProdotto",FILTER_SANITIZE_NUMBER_INT);
	$carrello->eliminaProdottoDalCarrello($idProdotto);
	
	if($carrello->getNumeroProdotti()==0) {
		$carrello->elimina();
		unset($_SESSION["carrello"]);
	}
	else {
		$carrello->aggiorna();
	}
	header("Location: ../../carrello.php");
    }
    else if($operazione=="crea") {
        $carrello->crea();
    }
    else if($operazione=="convertiInOrdine") {
        $carrello->caricaDatiDalDatabase();
        $nome    = filter_input(INPUT_GET,'nome',FILTER_SANITIZE_ADD_SLASHES);
        $cognome = filter_input(INPUT_GET,'cognome',FILTER_SANITIZE_ADD_SLASHES);
        $via     = filter_input(INPUT_GET,'via',FILTER_SANITIZE_ADD_SLASHES);
        $citta   = filter_input(INPUT_GET,'citta',FILTER_SANITIZE_ADD_SLASHES);
        $capSpedizione = filter_input(INPUT_GET,'capSpedizione',FILTER_SANITIZE_ADD_SLASHES);
        $email         = filter_input(INPUT_GET,'email',FILTER_SANITIZE_ADD_SLASHES);
        $telefono      = filter_input(INPUT_GET,'telefono',FILTER_SANITIZE_ADD_SLASHES);
        $spedizione    = filter_input(INPUT_GET,'spedizione',FILTER_SANITIZE_ADD_SLASHES);
        $tipoPagamento = filter_input(INPUT_GET,'tipoPagamento',FILTER_SANITIZE_ADD_SLASHES);
        $tipoRicevuta  = filter_input(INPUT_GET,'tipoRicevuta',FILTER_SANITIZE_ADD_SLASHES);
        $partitaIva    = filter_input(INPUT_GET,'partitaIva',FILTER_SANITIZE_ADD_SLASHES);
        $codiceFiscale = filter_input(INPUT_GET,'codiceFiscale',FILTER_SANITIZE_ADD_SLASHES);
        
        $_SESSION["idOrdine"] = $carrello->convertiInOrdine($nome,$cognome,$via,$citta,$capSpedizione,$email,$telefono,$spedizione,$tipoPagamento,$partitaIva,$codiceFiscale,$tipoRicevuta);
        
        if($tipoPagamento=="Pagamento alla consegna") {
        	$carrello->aggiornaDisponibilitaNegozio();
        }
        
        $notifica = new Notifica($geecomDb, 0);
        $notifica->setProdotto("CMS");
        $notifica->setTipo("nuovoOrdine");
        $notifica->setTesto("$nome $cognome ha effettuato un ordine");
        $notifica->setLink(GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni, $datiCMS)."/componenti/ecommerce/dettagliOrdine.php?id={$_SESSION["idOrdine"]}");
        $notifica->crea();
	echo "ok";
    }
    else if($operazione=="modificaQuantita") {
        $carrello->caricaDatiDalDatabase();
        $idProdotto = $_GET["prodotto"];
        $quantita = $_GET["quantitaProdotto"];
        if(is_numeric($idProdotto) && is_numeric($quantita)){
            $carrello->modificaQuantitaProdotto($idProdotto,$quantita);
        }
        header("Location: ../../carrello.php");
    }
    else if($operazione=="modificaSpedizione") {
        $idSpedizione = $_GET["idSpedizione"];
        if(is_numeric($idSpedizione)){
            $carrello->modificaSpedizione($idSpedizione);
            echo "ok";
        }
    }
    else if($operazione=="associaCarrelloUtente") {
        $idUtente = $_GET["id"];
        if(is_numeric($idUtente)){
            $carrello->associaCarrelloUtente($idUtente);
            echo "ok";
        }
    }
    else if($operazione=="aggiungiBuonoSconto") {
        $buono = filter_input(INPUT_GET,"buonoSconto",FILTER_SANITIZE_ADD_SLASHES);
        $carrello->caricaDatiDalDatabase();
        $esito = $carrello->inserisciBuonoSconto($buono);
        echo $esito;
    }
    else if($operazione=="stampaNumeroProdottiCarrello") {
        $carrello->caricaDatiDalDatabase();
        echo count($carrello->getProdottiNelCarrello());
    }
    else if($operazione=="aggiornaDatiUtenteCarrello") {
        $carrello->caricaDatiDalDatabase();
        
        $nome 	   = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_ADD_SLASHES);
        $cognome   = filter_input(INPUT_POST, "cognome",FILTER_SANITIZE_ADD_SLASHES);
        $telefono  = filter_input(INPUT_POST, "telefono",FILTER_SANITIZE_ADD_SLASHES);
        $email     = filter_input(INPUT_POST, "email",FILTER_SANITIZE_EMAIL);
        $nazione   = filter_input(INPUT_POST, "nazione",FILTER_SANITIZE_ADD_SLASHES);
        $citta     = filter_input(INPUT_POST, "citta",FILTER_SANITIZE_ADD_SLASHES);
        $indirizzo = filter_input(INPUT_POST, "indirizzo",FILTER_SANITIZE_ADD_SLASHES);
        $cap       = filter_input(INPUT_POST, "capSpedizione",FILTER_SANITIZE_ADD_SLASHES);
        $codiceFiscale = filter_input(INPUT_POST, "codiceFiscale",FILTER_SANITIZE_ADD_SLASHES);
        $partitaIva    = filter_input(INPUT_POST, "partitaIva",FILTER_SANITIZE_ADD_SLASHES);
                
        $carrello->aggiornaDatiCliente($nome,$cognome,$telefono,$email,$nazione,$citta,$indirizzo,$cap,$codiceFiscale,$partitaIva);
                
        $carrello->setCapSpedizione($cap);
        $carrello->aggiornaCostoSpedizione();
        echo "ok";
    }
    else if($operazione=="stampaNumeroProdottiCarrello") {
        $carrello->caricaDatiDalDatabase();
        echo count($carrello->getProdottiNelCarrello());
    }
    else { // operazione=="inserisciProdotto" o aggiornaProdottoCarrello
        $idProdotto   = filter_input(INPUT_GET, "prodotto",FILTER_SANITIZE_NUMBER_INT);
        $idVariazione = filter_input(INPUT_GET, "idVariazione",FILTER_SANITIZE_NUMBER_INT);
        $quantita     = filter_input(INPUT_GET, "quantitaProdotto",FILTER_SANITIZE_NUMBER_INT);
        
        if(isset($_GET["attributo"])) {
            $attributo = $_GET["attributo"];
        }
        else {
           $attributo = "";
        }
        $carrello->caricaDatiDalDatabase();
        
        if($operazione=="inserisciProdotto") {
	    if(!isset($_SESSION["carrello"])) {
                $arrayNazioni = explode(",",$impostazioniEcommerce["nazioniDaVisualizzare"]);
                $nazione = ($impostazioniEcommerce["attivaAreeGeografiche"]=="si") ? array_shift($arrayNazioni): "";
                $carrello->setNazione($nazione);
                $carrello->crea();
                $carrello->aggiungiProdottoAlCarrello($idProdotto,$idVariazione,$quantita,$attributo);
                if(isset($_SESSION["geecomUser_id"])) { // se l'utente è loggato il carrello viene associato al suo id
                    $carrello->associaCarrelloUtente($_SESSION["geecomUser_id"]);
                }
                $carrello->aggiorna();
                $_SESSION["carrello"] = $carrello->getId();
                echo"ok";
            }
	    else {
                $carrello->aggiungiProdottoAlCarrello($idProdotto,$idVariazione,$quantita,$attributo);
                echo"ok";
	    }
        }
        else if($operazione=="inserisciProdottoDropshipping") {
            $nomeProdotto = filter_input(INPUT_GET, "titolo",FILTER_SANITIZE_ADD_SLASHES);
            $prezzo       = filter_input(INPUT_GET, "prezzo",FILTER_SANITIZE_ADD_SLASHES);
            
	    if(!isset($_SESSION["carrello"])) {
                $carrello->crea();
                $carrello->aggiungiProdottoDropshippingAlCarrello($idProdotto,$nomeProdotto,$quantita,$attributo,$prezzo);
                $carrello->aggiorna();
                $_SESSION["carrello"] = $carrello->getId();
                echo"ok";
            }
	    else {
                $carrello->aggiungiProdottoDropshippingAlCarrello($idProdotto,$nomeProdotto,$quantita,$attributo,$prezzo);
                echo"ok";
	    }
        }
	elseif($operazione=="aggiornaProdottoCarrello") {
            $quantity = $_GET["productQuantity"];
            if(is_numeric($idProdotto) && is_numeric($quantita)){
                $carrello->updateProductCart($idProduct,$quantity);
                header("Location: ../../riepilogo.php?company=$company");
            }
	}
        elseif($operazione=="impostaOrdineStripePagato") {
            $idTransazione = filter_input(INPUT_POST, "idTransazione",FILTER_SANITIZE_ADD_SLASHES);
            $idOrdine = $_SESSION["idOrdine"];
            $query = "UPDATE geecEc_ordini SET stato = 'pagato', idTransazione='$idTransazione' WHERE id = $idOrdine";
            $geecomDb->eseguiQueryScrittura($query);
            $carrello->aggiornaDisponibilitaNegozio();
            echo "ok";
	}
        elseif($operazione=="impostaOrdinePayPalPagato") {
            $carrello->caricaDatiDalDatabase();
            $idTransazione = filter_input(INPUT_POST, "idTransazione",FILTER_SANITIZE_ADD_SLASHES);
            $idOrdine = $_SESSION["idOrdine"];
            
            // eseguo la cattura dell'ordine PayPal
            $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti", 1);
            $sandbox = ($impostazioniPagamenti["sandboxPaypal"]=="si") ? true : false;
    
            $connettore = new ConnettorePayPal($impostazioniPagamenti["clientIdPaypal"],$impostazioniPagamenti["secretPaypal"],$sandbox);
            $connettore->richiediAccessToken();
            $esitoChiamata = $connettore->catturaPagamento($idTransazione);
            
            $esitoChiamataJson = json_decode($esitoChiamata);
            $status = $esitoChiamataJson->purchase_units[0]->payments->captures[0]->status;
            
            if($status=="COMPLETED") {
		    $query = "UPDATE geecEc_ordini SET stato = 'pagato', idTransazione='$idTransazione' WHERE id = $idOrdine";
		    $geecomDb->eseguiQueryScrittura($query);
		    $carrello->aggiornaDisponibilitaNegozio();
		    echo "ok";
            }
            else if($status=="DECLINED") {
		    $query = "UPDATE geecEc_ordini SET stato = 'pagamento rifiutato dalla banca', idTransazione='$idTransazione' WHERE id = $idOrdine";
		    $geecomDb->eseguiQueryScrittura($query);
		    echo "Errore: la tua carta è stata declinata!";
            }
            else {
		    $query = "UPDATE geecEc_ordini SET stato = 'errore pagamento', idTransazione='$idTransazione' WHERE id = $idOrdine";
		    $geecomDb->eseguiQueryScrittura($query);
		    echo "Errore durante il pagamento";
            }
	}	
        elseif($operazione=="stampaCostoProdottiETotale") {
            $carrello->caricaDatiDalDatabase();
            echo $carrello->getImportoProdotti()."-".$carrello->getImportoTotale();
	}
   }
